#ifndef PARSER_ATP_SST_MM_H
#define PARSER_ATP_SST_MM_H

/*
   *  Object          : parser_atp_Sst_mm.h
   *  State           :  %state%
   *  Creation date   :  Apr  13  2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief  This file includes the DH parsing functions  
   *         
   *
   *  \version parser_atp_Sst_mm.h#1:csrc:3
   *  \author TaniaM
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************* Include Files ****************/

#include "msg_defs.h"
#include "SST_SEP_TST.h"
#include "sst_errors.h"
#include "sst_sep_errors.h"

/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_MM_1
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_SST_InitTerminate first part finction.
* It calls the SEP function with parameters parsed from input message
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_PARSER_SST_MM_1(DxUint32_t* msg);
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_MM_2
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_SST_InitTerminate second  part finction.
* It calls the SEP function with parameters parsed from input message
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/
DxUint32_t DX_SEP_PARSER_SST_MM_2(DxUint32_t* msg);
#endif
